-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1:3306
-- Generation Time: Dec 08, 2025 at 12:44 AM
-- Server version: 8.2.0
-- PHP Version: 8.2.13

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `goldhldz_onlinedesign`
--

DELIMITER $$
--
-- Procedures
--
DROP PROCEDURE IF EXISTS `update_bank_account_balance`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `update_bank_account_balance` (IN `bank_account_id` INT)   BEGIN
    DECLARE new_balance DECIMAL(15,2);
    
    SELECT COALESCE(SUM(debit_amount) - SUM(credit_amount), 0) INTO new_balance
    FROM transactions 
    WHERE account_type = 'bank' 
      AND account_id = bank_account_id
      AND is_reversed = 0;
    
    UPDATE bank_accounts 
    SET current_balance = new_balance,
        updated_at = NOW()
    WHERE id = bank_account_id;
END$$

DROP PROCEDURE IF EXISTS `update_cash_box_balance`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `update_cash_box_balance` (IN `cash_box_id` INT)   BEGIN
    DECLARE new_balance DECIMAL(15,2);
    
    SELECT COALESCE(SUM(debit_amount) - SUM(credit_amount), 0) INTO new_balance
    FROM transactions 
    WHERE account_type = 'cash' 
      AND account_id = cash_box_id
      AND is_reversed = 0;
    
    UPDATE cash_boxes 
    SET current_balance = new_balance,
        updated_at = NOW()
    WHERE id = cash_box_id;
END$$

DROP PROCEDURE IF EXISTS `update_company_balance`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `update_company_balance` (IN `company_id` INT)   BEGIN
    DECLARE new_balance DECIMAL(15,2);
    
    SELECT COALESCE(SUM(credit_amount) - SUM(debit_amount), 0) INTO new_balance
    FROM transactions 
    WHERE account_type = 'company' 
      AND account_id = company_id
      AND is_reversed = 0;
    
    UPDATE companies 
    SET current_balance = new_balance,
        updated_at = NOW()
    WHERE id = company_id;
END$$

DROP PROCEDURE IF EXISTS `update_customer_balance`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `update_customer_balance` (IN `customer_id` INT)   BEGIN
    DECLARE new_balance DECIMAL(15,2);
    
    SELECT COALESCE(SUM(debit_amount) - SUM(credit_amount), 0) INTO new_balance
    FROM transactions 
    WHERE account_type = 'customer' 
      AND account_id = customer_id
      AND is_reversed = 0;
    
    UPDATE customers 
    SET current_balance = new_balance,
        updated_at = NOW()
    WHERE id = customer_id;
END$$

--
-- Functions
--
DROP FUNCTION IF EXISTS `calculate_account_balance`$$
CREATE DEFINER=`root`@`localhost` FUNCTION `calculate_account_balance` (`account_type_param` ENUM('customer','company','cash','bank'), `account_id_param` INT) RETURNS DECIMAL(15,2) DETERMINISTIC READS SQL DATA BEGIN
    DECLARE balance DECIMAL(15,2) DEFAULT 0.00;
    
    SELECT 
        COALESCE(SUM(debit_amount) - SUM(credit_amount), 0) INTO balance
    FROM transactions
    WHERE account_type = account_type_param 
      AND account_id = account_id_param
      AND is_reversed = 0;
    
    RETURN balance;
END$$

DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `activity_logs`
--

DROP TABLE IF EXISTS `activity_logs`;
CREATE TABLE IF NOT EXISTS `activity_logs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `action` varchar(50) NOT NULL,
  `entity_type` varchar(50) NOT NULL,
  `entity_id` int NOT NULL,
  `old_values` json DEFAULT NULL,
  `new_values` json DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_activity_logs_user_id` (`user_id`),
  KEY `idx_activity_logs_entity` (`entity_type`,`entity_id`)
) ENGINE=MyISAM AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `activity_logs`
--

INSERT INTO `activity_logs` (`id`, `user_id`, `action`, `entity_type`, `entity_id`, `old_values`, `new_values`, `ip_address`, `user_agent`, `created_at`) VALUES
(25, 1, 'create', 'bank_account', 5, NULL, '{\"name\": \"حساب الكريمي\", \"opening_balance\": 0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-06 19:08:15'),
(22, 1, 'create', 'cash_box', 3, NULL, '{\"name\": \"صندوق رقم 2\", \"opening_balance\": 5000}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-05 19:56:45'),
(23, 1, 'create', 'bank_account', 3, NULL, '{\"name\": \"حساب الكريمي\", \"opening_balance\": 0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-05 19:57:33'),
(24, 1, 'create', 'bank_account', 4, NULL, '{\"name\": \"حساب الكريمي\", \"opening_balance\": 0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-05 20:06:00'),
(21, 1, 'create', 'voucher', 13, NULL, '{\"type\": \"receipt\", \"amount\": 5000, \"voucher_number\": \"VCHR-20251205225429279\"}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-05 19:54:29'),
(19, 1, 'create', 'voucher', 10, NULL, '{\"type\": \"receipt\", \"amount\": 30000, \"voucher_number\": \"VCHR-20251205215055936\"}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-05 18:50:55'),
(20, 1, 'create', 'voucher', 12, NULL, '{\"type\": \"receipt\", \"amount\": 700, \"voucher_number\": \"VCHR-20251205225332725\"}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-05 19:53:32'),
(18, 1, 'create', 'bank_account', 2, 'null', '{\"name\": \"حساب الكريمي\", \"bank_name\": \"الكريمي\", \"account_number\": \"543545635\", \"opening_balance\": \"0\"}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-05 21:25:52'),
(17, 1, 'create', 'cash_box', 2, 'null', '{\"name\": \"صندوق رقم 1\", \"description\": \"\", \"opening_balance\": \"0\"}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-05 21:25:20'),
(16, 1, 'create', 'item', 7, NULL, '{\"name\": \"بسكويت ابو ولد\", \"image\": \"69334ce61bf15_1764969702.jpg\", \"model\": \"5785343\", \"unit_id\": 1, \"company_id\": 4, \"current_stock\": 0, \"default_price\": 5000, \"specifications\": \"حالي قوي\"}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-05 21:21:42'),
(15, 1, 'create', 'company', 4, NULL, '{\"name\": \"شركة الصناعات المتنوعه\", \"phone\": \"763124875\", \"address\": \"تعز الحوبان\", \"opening_balance\": 8000}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-05 21:20:38'),
(14, 1, 'create', 'customer', 7, NULL, '{\"name\": \"محمد احمد\", \"phone\": \"784542725\", \"address\": \"تعزالحوبان\", \"opening_balance\": 5000}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-05 21:20:02'),
(13, 1, 'login', 'user', 1, NULL, '{\"ip\": \"::1\", \"user_agent\": \"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36\"}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-05 21:18:40'),
(26, 1, 'create', 'bank_account', 6, NULL, '{\"name\": \"حساب الكريمي\", \"opening_balance\": 0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-06 19:11:47'),
(27, 1, 'create', 'bank_account', 7, NULL, '{\"name\": \"حساب الكريمي\", \"opening_balance\": 0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-06 19:13:58'),
(28, 1, 'create', 'cash_box', 4, NULL, '{\"name\": \"صندوق رقم 1\", \"opening_balance\": 5000}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-06 19:21:30'),
(29, 1, 'create', 'bank_account', 8, NULL, '{\"name\": \"حساب احمد شوقي\", \"opening_balance\": 0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-06 19:21:52'),
(30, 1, 'create', 'bank_account', 9, NULL, '{\"name\": \"حساب احمد شوقي\", \"opening_balance\": 0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-06 19:23:13'),
(31, 1, 'create', 'bank_account', 10, NULL, '{\"name\": \"حساب احمد شوقي\", \"opening_balance\": 0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-06 19:23:22'),
(32, 1, 'create', 'bank_account', 11, NULL, '{\"name\": \"حساب احمد شوقي\", \"opening_balance\": 0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-06 19:23:32'),
(33, 1, 'create', 'bank_account', 12, NULL, '{\"name\": \"حساب احمد شوقي\", \"opening_balance\": 0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-06 19:33:12'),
(34, 1, 'create', 'bank_account', 13, NULL, '{\"name\": \"حساب احمد شوقي\", \"opening_balance\": 0}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-06 19:43:05'),
(35, 1, 'create', 'voucher', 14, NULL, '{\"type\": \"receipt\", \"amount\": 30000, \"voucher_number\": \"VCHR-20251206225813265\"}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-06 19:58:13'),
(36, 1, 'create', 'voucher', 15, NULL, '{\"type\": \"receipt\", \"amount\": 700, \"voucher_number\": \"VCHR-20251206230420578\"}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-06 20:04:20'),
(37, 1, 'create', 'voucher', 16, NULL, '{\"type\": \"receipt\", \"amount\": 3000, \"voucher_number\": \"VCHR-20251206230521740\"}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-06 20:05:21'),
(38, 1, 'create', 'bank_account', 14, NULL, '{\"name\": \"بنك اليمن الدولي\", \"opening_balance\": 5000}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-06 20:11:09'),
(39, 1, 'create', 'bank_account', 15, NULL, '{\"name\": \"بنك اليمن الدولي\", \"opening_balance\": 5000}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-06 20:12:31'),
(40, 1, 'login', 'user', 1, NULL, '{\"ip\": \"::1\", \"user_agent\": \"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36\"}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-07 21:54:49'),
(41, 1, 'create', 'bank_account', 16, NULL, '{\"name\": \"بنك اليمن الدولي\", \"opening_balance\": 5000}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-07 20:06:49'),
(42, 1, 'login', 'user', 1, NULL, '{\"ip\": \"::1\", \"user_agent\": \"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36\"}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-07 23:56:49'),
(43, 1, 'create', 'customer', 8, NULL, '{\"name\": \"علي\", \"phone\": \"5548653\", \"address\": \"jghk\", \"opening_balance\": 1000}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-08 00:06:04'),
(44, 1, 'create', 'bank_account', 17, NULL, '{\"name\": \"بنك اليمن الدولي\", \"opening_balance\": 5000}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-07 21:15:29');

-- --------------------------------------------------------

--
-- Table structure for table `bank_accounts`
--

DROP TABLE IF EXISTS `bank_accounts`;
CREATE TABLE IF NOT EXISTS `bank_accounts` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `bank_name` varchar(255) NOT NULL,
  `account_number` varchar(100) NOT NULL,
  `branch_name` varchar(255) DEFAULT NULL,
  `iban` varchar(50) DEFAULT NULL,
  `swift_code` varchar(20) DEFAULT NULL,
  `opening_balance` decimal(15,2) DEFAULT '0.00',
  `current_balance` decimal(15,2) DEFAULT '0.00',
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `bank_accounts`
--

INSERT INTO `bank_accounts` (`id`, `name`, `bank_name`, `account_number`, `branch_name`, `iban`, `swift_code`, `opening_balance`, `current_balance`, `is_active`, `created_at`, `updated_at`) VALUES
(17, 'بنك اليمن الدولي', 'بنك اليمن الدولي', '5453512', '', '65485', '', 5000.00, 5000.00, 0, '2025-12-07 21:15:29', '2025-12-07 21:15:29'),
(16, 'بنك اليمن الدولي', 'بنك اليمن الدولي', '5453512', '', '65485', '', 5000.00, 5000.00, 0, '2025-12-07 20:06:49', '2025-12-07 20:06:49'),
(15, 'بنك اليمن الدولي', 'بنك اليمن الدولي', '5453512', '', '65485', '', 5000.00, 5000.00, 0, '2025-12-06 20:12:31', '2025-12-06 20:12:31'),
(14, 'بنك اليمن الدولي', 'بنك اليمن الدولي', '5453512', '', '65485', '', 5000.00, -3000.00, 1, '2025-12-06 20:11:09', '2025-12-06 20:13:09');

-- --------------------------------------------------------

--
-- Stand-in structure for view `bank_account_balances`
-- (See below for the actual view)
--
DROP VIEW IF EXISTS `bank_account_balances`;
CREATE TABLE IF NOT EXISTS `bank_account_balances` (
`account_number` varchar(100)
,`bank_name` varchar(255)
,`current_balance` decimal(38,2)
,`id` int
,`name` varchar(255)
);

-- --------------------------------------------------------

--
-- Table structure for table `cash_boxes`
--

DROP TABLE IF EXISTS `cash_boxes`;
CREATE TABLE IF NOT EXISTS `cash_boxes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` text,
  `opening_balance` decimal(15,2) DEFAULT '0.00',
  `current_balance` decimal(15,2) DEFAULT '0.00',
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `cash_boxes`
--

INSERT INTO `cash_boxes` (`id`, `name`, `description`, `opening_balance`, `current_balance`, `is_active`, `created_at`, `updated_at`) VALUES
(4, 'صندوق رقم 1', '', 5000.00, 8700.00, 1, '2025-12-06 19:21:30', '2025-12-07 20:17:24');

-- --------------------------------------------------------

--
-- Stand-in structure for view `cash_box_balances`
-- (See below for the actual view)
--
DROP VIEW IF EXISTS `cash_box_balances`;
CREATE TABLE IF NOT EXISTS `cash_box_balances` (
`current_balance` decimal(38,2)
,`description` text
,`id` int
,`name` varchar(255)
);

-- --------------------------------------------------------

--
-- Table structure for table `companies`
--

DROP TABLE IF EXISTS `companies`;
CREATE TABLE IF NOT EXISTS `companies` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `address` text,
  `opening_balance` decimal(15,2) DEFAULT '0.00',
  `current_balance` decimal(15,2) DEFAULT '0.00',
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `companies`
--

INSERT INTO `companies` (`id`, `name`, `phone`, `address`, `opening_balance`, `current_balance`, `is_active`, `created_at`, `updated_at`) VALUES
(4, 'شركة الصناعات المتنوعه', '763124875', 'تعز الحوبان', 8000.00, 248000.00, 1, '2025-12-05 21:20:38', '2025-12-08 00:30:03');

-- --------------------------------------------------------

--
-- Stand-in structure for view `company_balances`
-- (See below for the actual view)
--
DROP VIEW IF EXISTS `company_balances`;
CREATE TABLE IF NOT EXISTS `company_balances` (
`address` text
,`current_balance` decimal(38,2)
,`id` int
,`name` varchar(255)
,`phone` varchar(20)
);

-- --------------------------------------------------------

--
-- Table structure for table `currencies`
--

DROP TABLE IF EXISTS `currencies`;
CREATE TABLE IF NOT EXISTS `currencies` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `code` varchar(3) NOT NULL,
  `symbol` varchar(10) DEFAULT NULL,
  `exchange_rate` decimal(15,6) NOT NULL,
  `is_default` tinyint(1) DEFAULT '0',
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `currencies`
--

INSERT INTO `currencies` (`id`, `name`, `code`, `symbol`, `exchange_rate`, `is_default`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'الريال السعودي', 'SAR', 'ر.س', 1.000000, 0, 1, '2025-12-01 21:16:47', '2025-12-01 21:22:13'),
(2, 'الدولار الأمريكي', 'USD', '$', 3.000000, 1, 1, '2025-12-01 21:16:47', '2025-12-01 21:22:13'),
(3, 'اليورو', 'EUR', '€', 4.100000, 0, 1, '2025-12-01 21:16:47', '2025-12-01 21:16:47');

-- --------------------------------------------------------

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
CREATE TABLE IF NOT EXISTS `customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `address` text,
  `opening_balance` decimal(15,2) DEFAULT '0.00',
  `current_balance` decimal(15,2) DEFAULT '0.00',
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `customers`
--

INSERT INTO `customers` (`id`, `name`, `phone`, `address`, `opening_balance`, `current_balance`, `is_active`, `created_at`, `updated_at`) VALUES
(8, 'علي', '5548653', 'jghk', 1000.00, 646000.00, 1, '2025-12-08 00:06:04', '2025-12-08 00:30:03'),
(7, 'محمد احمد', '784542725', 'تعزالحوبان', 5000.00, 19000.00, 1, '2025-12-05 21:20:02', '2025-12-06 23:05:21');

-- --------------------------------------------------------

--
-- Stand-in structure for view `customer_balances`
-- (See below for the actual view)
--
DROP VIEW IF EXISTS `customer_balances`;
CREATE TABLE IF NOT EXISTS `customer_balances` (
`address` text
,`current_balance` decimal(38,2)
,`id` int
,`name` varchar(255)
,`phone` varchar(20)
);

-- --------------------------------------------------------

--
-- Table structure for table `invoices`
--

DROP TABLE IF EXISTS `invoices`;
CREATE TABLE IF NOT EXISTS `invoices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_number` varchar(100) NOT NULL,
  `customer_id` int NOT NULL,
  `currency_id` int NOT NULL,
  `exchange_rate` decimal(15,6) NOT NULL,
  `office_commission` decimal(5,2) DEFAULT '0.00',
  `shipping_costs` decimal(15,2) DEFAULT '0.00',
  `certificate_costs` decimal(15,2) DEFAULT '0.00',
  `total_amount` decimal(15,2) DEFAULT '0.00',
  `total_amount_local` decimal(15,2) DEFAULT '0.00',
  `status` enum('draft','confirmed','cancelled') DEFAULT 'draft',
  `notes` text,
  `created_by` int NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `invoice_number` (`invoice_number`),
  KEY `currency_id` (`currency_id`),
  KEY `created_by` (`created_by`),
  KEY `idx_invoices_customer_id` (`customer_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `invoices`
--

INSERT INTO `invoices` (`id`, `invoice_number`, `customer_id`, `currency_id`, `exchange_rate`, `office_commission`, `shipping_costs`, `certificate_costs`, `total_amount`, `total_amount_local`, `status`, `notes`, `created_by`, `created_at`, `updated_at`) VALUES
(2, 'INV-2025-12-0001', 7, 1, 1.000000, 500.00, 100.00, 100.00, 25700.00, 25700.00, 'draft', NULL, 1, '2025-12-05 21:23:05', '2025-12-05 21:23:54'),
(3, 'INV-2025-12-0002', 8, 2, 3.000000, 0.00, 0.00, 0.00, 215000.00, 645000.00, 'draft', NULL, 1, '2025-12-08 00:29:32', '2025-12-08 00:30:03');

-- --------------------------------------------------------

--
-- Table structure for table `invoice_audit`
--

DROP TABLE IF EXISTS `invoice_audit`;
CREATE TABLE IF NOT EXISTS `invoice_audit` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` int NOT NULL,
  `action` varchar(50) NOT NULL,
  `old_values` json DEFAULT NULL,
  `new_values` json DEFAULT NULL,
  `changed_by` int NOT NULL,
  `changed_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `invoice_id` (`invoice_id`),
  KEY `changed_by` (`changed_by`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `invoice_items`
--

DROP TABLE IF EXISTS `invoice_items`;
CREATE TABLE IF NOT EXISTS `invoice_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` int NOT NULL,
  `item_id` int NOT NULL,
  `company_id` int DEFAULT NULL,
  `quantity` decimal(15,3) NOT NULL,
  `unit_price` decimal(15,2) NOT NULL,
  `total_price` decimal(15,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `weight_id` int DEFAULT NULL,
  `carton_id` int DEFAULT NULL,
  `cbm_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`),
  KEY `idx_invoice_items_invoice_id` (`invoice_id`),
  KEY `idx_invoice_items_item_id` (`item_id`),
  KEY `idx_invoice_items_weight_key` (`weight_id`),
  KEY `idx_invoice_items_carton_key` (`carton_id`),
  KEY `idx_invoice_items_cbm_key` (`cbm_id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `invoice_items`
--

INSERT INTO `invoice_items` (`id`, `invoice_id`, `item_id`, `company_id`, `quantity`, `unit_price`, `total_price`, `created_at`, `weight_id`, `carton_id`, `cbm_id`) VALUES
(6, 3, 7, 4, 43.000, 5000.00, 215000.00, '2025-12-08 00:30:03', NULL, NULL, NULL),
(5, 2, 7, 4, 5.000, 5000.00, 25000.00, '2025-12-05 21:23:26', NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `items`
--

DROP TABLE IF EXISTS `items`;
CREATE TABLE IF NOT EXISTS `items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `image` varchar(500) DEFAULT NULL,
  `default_price` decimal(15,2) DEFAULT '0.00',
  `model` varchar(100) DEFAULT NULL,
  `specifications` text,
  `unit_id` int NOT NULL,
  `company_id` int DEFAULT NULL,
  `current_stock` decimal(15,3) DEFAULT '0.000',
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `unit_id` (`unit_id`),
  KEY `company_id` (`company_id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `items`
--

INSERT INTO `items` (`id`, `name`, `image`, `default_price`, `model`, `specifications`, `unit_id`, `company_id`, `current_stock`, `is_active`, `created_at`, `updated_at`) VALUES
(7, 'بسكويت ابو ولد', '69334ce61bf15_1764969702.jpg', 5000.00, '5785343', 'حالي قوي', 1, 4, 0.000, 1, '2025-12-05 21:21:42', '2025-12-05 21:21:42');

-- --------------------------------------------------------

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
CREATE TABLE IF NOT EXISTS `roles` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `permissions` json NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `roles`
--

INSERT INTO `roles` (`id`, `name`, `permissions`, `created_at`) VALUES
(1, 'Admin', '{\"users\": [\"create\", \"read\", \"update\", \"delete\"], \"reports\": [\"read\"], \"invoices\": [\"create\", \"read\", \"update\", \"delete\"], \"companies\": [\"create\", \"read\", \"update\", \"delete\"], \"customers\": [\"create\", \"read\", \"update\", \"delete\"]}', '2025-12-01 21:16:47'),
(2, 'Accountant', '{\"reports\": [\"read\"], \"invoices\": [\"create\", \"read\", \"update\"], \"companies\": [\"create\", \"read\", \"update\"], \"customers\": [\"create\", \"read\", \"update\"]}', '2025-12-01 21:16:47'),
(3, 'Clerk', '{\"invoices\": [\"create\", \"read\"], \"companies\": [\"read\"], \"customers\": [\"read\"]}', '2025-12-01 21:16:47');

-- --------------------------------------------------------

--
-- Table structure for table `shared_cartons`
--

DROP TABLE IF EXISTS `shared_cartons`;
CREATE TABLE IF NOT EXISTS `shared_cartons` (
  `id` int NOT NULL AUTO_INCREMENT,
  `total_cartons` int NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `shared_cbm`
--

DROP TABLE IF EXISTS `shared_cbm`;
CREATE TABLE IF NOT EXISTS `shared_cbm` (
  `id` int NOT NULL AUTO_INCREMENT,
  `total_cbm` decimal(15,6) NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `shared_weights`
--

DROP TABLE IF EXISTS `shared_weights`;
CREATE TABLE IF NOT EXISTS `shared_weights` (
  `id` int NOT NULL AUTO_INCREMENT,
  `total_weight` decimal(15,3) NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `stock_transactions`
--

DROP TABLE IF EXISTS `stock_transactions`;
CREATE TABLE IF NOT EXISTS `stock_transactions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `item_id` int NOT NULL,
  `type` enum('in','out') NOT NULL,
  `quantity` decimal(15,3) NOT NULL,
  `reference_type` enum('invoice','purchase','adjustment') NOT NULL,
  `reference_id` int NOT NULL,
  `notes` text,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_stock_transactions_item_id` (`item_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `transactions`
--

DROP TABLE IF EXISTS `transactions`;
CREATE TABLE IF NOT EXISTS `transactions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `account_type` enum('customer','company','cash','bank') NOT NULL,
  `voucher_type` enum('receipt','payment') DEFAULT NULL,
  `account_id` int NOT NULL,
  `related_invoice_id` int DEFAULT NULL,
  `related_voucher_id` int DEFAULT NULL,
  `debit_amount` decimal(15,2) DEFAULT '0.00',
  `credit_amount` decimal(15,2) DEFAULT '0.00',
  `description` text,
  `balance_after` decimal(15,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `payment_method` enum('cash','bank') DEFAULT 'cash',
  `is_reversed` tinyint(1) DEFAULT '0',
  `reversed_at` timestamp NULL DEFAULT NULL,
  `reversed_by` int DEFAULT NULL,
  `cash_box_id` int DEFAULT NULL,
  `bank_account_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `related_invoice_id` (`related_invoice_id`),
  KEY `related_voucher_id` (`related_voucher_id`),
  KEY `idx_transactions_account` (`account_type`,`account_id`),
  KEY `idx_transactions_date` (`date`),
  KEY `reversed_by` (`reversed_by`),
  KEY `idx_transactions_voucher` (`voucher_type`,`related_voucher_id`),
  KEY `idx_transactions_cash_box` (`cash_box_id`),
  KEY `idx_transactions_bank_account` (`bank_account_id`)
) ENGINE=MyISAM AUTO_INCREMENT=56 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `transactions`
--

INSERT INTO `transactions` (`id`, `date`, `account_type`, `voucher_type`, `account_id`, `related_invoice_id`, `related_voucher_id`, `debit_amount`, `credit_amount`, `description`, `balance_after`, `created_at`, `payment_method`, `is_reversed`, `reversed_at`, `reversed_by`, `cash_box_id`, `bank_account_id`) VALUES
(44, '2025-12-06', 'company', NULL, 4, NULL, 17, 25000.00, 0.00, 'سند صرف الى company (شركة الصناعات المتنوعه) - VCHR-20251206230627257', 58000.00, '2025-12-06 20:06:27', 'cash', 0, NULL, NULL, NULL, NULL),
(43, '2025-12-06', 'cash', 'receipt', 4, NULL, 17, 0.00, 25000.00, 'سند صرف #VCHR-20251206230627257 - عليكم دفعه من حسابكم', 13700.00, '2025-12-06 20:06:27', 'cash', 0, NULL, NULL, NULL, NULL),
(42, '2025-12-06', 'customer', NULL, 7, NULL, 16, 0.00, 3000.00, 'سند قبض من customer (محمد احمد) - VCHR-20251206230521740', 22000.00, '2025-12-06 20:05:21', 'cash', 0, NULL, NULL, NULL, NULL),
(41, '2025-12-06', 'cash', 'receipt', 4, NULL, 16, 3000.00, 0.00, 'سند قبض #VCHR-20251206230521740 - فعه مقدمه', 38700.00, '2025-12-06 20:05:21', 'cash', 0, NULL, NULL, NULL, NULL),
(40, '2025-12-06', 'customer', NULL, 7, NULL, 15, 0.00, 700.00, 'سند قبض من customer (محمد احمد) - VCHR-20251206230420578', 25000.00, '2025-12-06 20:04:20', 'cash', 0, NULL, NULL, NULL, NULL),
(38, '2025-12-06', 'customer', NULL, 7, NULL, 14, 0.00, 30000.00, 'سند قبض من customer (محمد احمد) - VCHR-20251206225813265', 25700.00, '2025-12-06 19:58:13', 'cash', 0, NULL, NULL, NULL, NULL),
(39, '2025-12-06', 'cash', 'receipt', 4, NULL, 15, 700.00, 0.00, 'سند قبض #VCHR-20251206230420578 - سداد حساب', 35700.00, '2025-12-06 20:04:20', 'cash', 0, NULL, NULL, NULL, NULL),
(36, '2025-12-06', 'cash', 'receipt', 4, NULL, NULL, 5000.00, 0.00, 'رصيد افتتاحي للصندوق: صندوق رقم 1', 5000.00, '2025-12-06 19:21:30', 'cash', 0, NULL, NULL, NULL, NULL),
(37, '2025-12-06', 'cash', 'receipt', 4, NULL, 14, 30000.00, 0.00, 'سند قبض #VCHR-20251206225813265 - لكم دفعه من الحساب', 35000.00, '2025-12-06 19:58:13', 'cash', 0, NULL, NULL, NULL, NULL),
(25, '2025-12-06', 'company', NULL, 4, 2, NULL, 0.00, 25000.00, 'مستحق من فاتورة مشتريات', 33000.00, '2025-12-05 21:23:26', 'cash', 0, NULL, NULL, NULL, NULL),
(26, '2025-12-06', 'customer', NULL, 7, 2, NULL, 25700.00, 0.00, 'فاتورة مشتريات - رصيد مدين', 55700.00, '2025-12-05 21:23:54', 'cash', 0, NULL, NULL, NULL, NULL),
(23, '2025-12-06', 'company', NULL, 4, NULL, NULL, 0.00, 8000.00, 'رصيد افتتاحي', -8000.00, '2025-12-05 21:20:38', 'cash', 0, NULL, NULL, NULL, NULL),
(22, '2025-12-06', 'customer', NULL, 7, NULL, NULL, 5000.00, 0.00, 'رصيد افتتاحي', 5000.00, '2025-12-05 21:20:02', 'cash', 0, NULL, NULL, NULL, NULL),
(45, '2025-12-06', 'bank', 'receipt', 14, NULL, NULL, 5000.00, 0.00, 'رصيد افتتاحي للحساب البنكي: بنك اليمن الدولي', 5000.00, '2025-12-06 20:11:09', 'bank', 0, NULL, NULL, NULL, NULL),
(46, '2025-12-06', 'bank', 'receipt', 15, NULL, NULL, 5000.00, 0.00, 'رصيد افتتاحي للحساب البنكي: بنك اليمن الدولي', 5000.00, '2025-12-06 20:12:31', 'bank', 0, NULL, NULL, NULL, NULL),
(47, '2025-12-06', 'bank', 'receipt', 14, NULL, 18, 0.00, 8000.00, 'سند صرف #VCHR-20251206231309295 - ', -3000.00, '2025-12-06 20:13:09', 'bank', 0, NULL, NULL, NULL, NULL),
(48, '2025-12-06', 'company', NULL, 4, NULL, 18, 8000.00, 0.00, 'سند صرف الى company (شركة الصناعات المتنوعه) - VCHR-20251206231309295', 66000.00, '2025-12-06 20:13:09', 'cash', 0, NULL, NULL, NULL, NULL),
(49, '2025-12-07', 'bank', 'receipt', 16, NULL, NULL, 5000.00, 0.00, 'رصيد افتتاحي للحساب البنكي: بنك اليمن الدولي', 5000.00, '2025-12-07 20:06:49', 'bank', 0, NULL, NULL, NULL, NULL),
(50, '2025-12-07', 'cash', 'receipt', 4, NULL, 19, 0.00, 5000.00, 'سند صرف #VCHR-20251207231724343 - عليكم دفعه من الحساب', 8700.00, '2025-12-07 20:17:24', 'cash', 0, NULL, NULL, NULL, NULL),
(51, '2025-12-07', 'company', NULL, 4, NULL, 19, 5000.00, 0.00, 'سند صرف الى company (شركة الصناعات المتنوعه) - VCHR-20251207231724343', 71000.00, '2025-12-07 20:17:24', 'cash', 0, NULL, NULL, NULL, NULL),
(52, '2025-12-08', 'customer', NULL, 8, NULL, NULL, 1000.00, 0.00, 'رصيد افتتاحي', 1000.00, '2025-12-08 00:06:04', 'cash', 0, NULL, NULL, NULL, NULL),
(53, '2025-12-08', 'bank', 'receipt', 17, NULL, NULL, 5000.00, 0.00, 'رصيد افتتاحي للحساب البنكي: بنك اليمن الدولي', 5000.00, '2025-12-07 21:15:29', 'bank', 0, NULL, NULL, NULL, NULL),
(54, '2025-12-08', 'customer', NULL, 8, 3, NULL, 645000.00, 0.00, 'فاتورة مشتريات - رصيد مدين', 646000.00, '2025-12-08 00:30:03', 'cash', 0, NULL, NULL, NULL, NULL),
(55, '2025-12-08', 'company', NULL, 4, 3, NULL, 0.00, 215000.00, 'مستحق من فاتورة مشتريات', 248000.00, '2025-12-08 00:30:03', 'cash', 0, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `units`
--

DROP TABLE IF EXISTS `units`;
CREATE TABLE IF NOT EXISTS `units` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `code` varchar(20) NOT NULL,
  `description` text,
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `units`
--

INSERT INTO `units` (`id`, `name`, `code`, `description`, `is_active`, `created_at`) VALUES
(1, 'كرتون', 'CTN', 'وحدة الكرتون', 1, '2025-12-01 21:16:47'),
(2, 'صندوق', 'BOX', 'وحدة الصندوق', 1, '2025-12-01 21:16:47'),
(3, 'قطعة', 'PCS', 'وحدة القطعة', 1, '2025-12-01 21:16:47'),
(4, 'كيلوجرام', 'KG', 'وحدة الوزن', 1, '2025-12-01 21:16:47'),
(5, 'متر مكعب', 'CBM', 'وحدة الحجم', 1, '2025-12-01 21:16:47');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
CREATE TABLE IF NOT EXISTS `users` (
  `id` int NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `email` varchar(50) NOT NULL,
  `password` varchar(255) NOT NULL,
  `role_id` int NOT NULL,
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `username`, `email`, `password`, `role_id`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'admin', 'admin@shipping.com', '$2y$10$.Dd/RtwoffoNqNi4hOC1duPsPp7hn7ulsDpz4HqoiVv0N0niTZID6', 1, 1, '2025-12-01 21:16:47', '2025-12-01 21:17:12'),
(2, 'accountant', 'accountant@shipping.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 2, 1, '2025-12-01 21:16:47', '2025-12-01 21:16:47'),
(3, 'clerk', 'clerk@shipping.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 3, 1, '2025-12-01 21:16:47', '2025-12-01 21:16:47');

-- --------------------------------------------------------

--
-- Table structure for table `vouchers`
--

DROP TABLE IF EXISTS `vouchers`;
CREATE TABLE IF NOT EXISTS `vouchers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `voucher_number` varchar(100) NOT NULL,
  `type` enum('receipt','payment') NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `currency_id` int NOT NULL,
  `exchange_rate` decimal(15,6) NOT NULL,
  `related_to` enum('customer','company','cash','bank') NOT NULL,
  `related_id` int NOT NULL,
  `cash_box_id` int DEFAULT NULL,
  `bank_account_id` int DEFAULT NULL,
  `description` text,
  `created_by` int NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `payment_type` enum('cash','bank','both') DEFAULT 'cash',
  `voucher_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `reference_number` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `voucher_number` (`voucher_number`),
  KEY `currency_id` (`currency_id`),
  KEY `created_by` (`created_by`),
  KEY `cash_box_id` (`cash_box_id`),
  KEY `bank_account_id` (`bank_account_id`),
  KEY `idx_vouchers_date` (`voucher_date`),
  KEY `idx_vouchers_type` (`type`),
  KEY `idx_vouchers_related` (`related_to`,`related_id`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `vouchers`
--

INSERT INTO `vouchers` (`id`, `voucher_number`, `type`, `amount`, `currency_id`, `exchange_rate`, `related_to`, `related_id`, `cash_box_id`, `bank_account_id`, `description`, `created_by`, `created_at`, `payment_type`, `voucher_date`, `reference_number`) VALUES
(19, 'VCHR-20251207231724343', 'payment', 5000.00, 1, 1.000000, 'company', 4, 4, 0, 'عليكم دفعه من الحساب', 1, '2025-12-07 20:17:24', '', '2025-12-07 23:17:24', NULL),
(18, 'VCHR-20251206231309295', 'payment', 8000.00, 1, 1.000000, 'company', 4, 0, 14, '', 1, '2025-12-06 20:13:09', '', '2025-12-06 23:13:09', NULL),
(17, 'VCHR-20251206230627257', 'payment', 25000.00, 1, 1.000000, 'company', 4, 4, 0, 'عليكم دفعه من حسابكم', 1, '2025-12-06 20:06:27', '', '2025-12-06 23:06:27', NULL),
(16, 'VCHR-20251206230521740', 'receipt', 3000.00, 1, 1.000000, 'customer', 7, 4, 0, 'فعه مقدمه', 1, '2025-12-06 20:05:21', '', '2025-12-06 23:05:21', NULL),
(15, 'VCHR-20251206230420578', 'receipt', 700.00, 1, 1.000000, 'customer', 7, 4, 0, 'سداد حساب', 1, '2025-12-06 20:04:20', '', '2025-12-06 23:04:20', NULL),
(14, 'VCHR-20251206225813265', 'receipt', 30000.00, 1, 1.000000, 'customer', 7, 4, 0, 'لكم دفعه من الحساب', 1, '2025-12-06 19:58:13', '', '2025-12-06 22:58:13', NULL);

-- --------------------------------------------------------

--
-- Structure for view `bank_account_balances`
--
DROP TABLE IF EXISTS `bank_account_balances`;

DROP VIEW IF EXISTS `bank_account_balances`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `bank_account_balances`  AS SELECT `ba`.`id` AS `id`, `ba`.`name` AS `name`, `ba`.`bank_name` AS `bank_name`, `ba`.`account_number` AS `account_number`, coalesce((sum(`t`.`debit_amount`) - sum(`t`.`credit_amount`)),0) AS `current_balance` FROM (`bank_accounts` `ba` left join `transactions` `t` on(((`t`.`account_type` = 'bank') and (`t`.`account_id` = `ba`.`id`) and (`t`.`is_reversed` = 0)))) GROUP BY `ba`.`id`, `ba`.`name`, `ba`.`bank_name`, `ba`.`account_number` ;

-- --------------------------------------------------------

--
-- Structure for view `cash_box_balances`
--
DROP TABLE IF EXISTS `cash_box_balances`;

DROP VIEW IF EXISTS `cash_box_balances`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `cash_box_balances`  AS SELECT `cb`.`id` AS `id`, `cb`.`name` AS `name`, `cb`.`description` AS `description`, coalesce((sum(`t`.`debit_amount`) - sum(`t`.`credit_amount`)),0) AS `current_balance` FROM (`cash_boxes` `cb` left join `transactions` `t` on(((`t`.`account_type` = 'cash') and (`t`.`account_id` = `cb`.`id`) and (`t`.`is_reversed` = 0)))) GROUP BY `cb`.`id`, `cb`.`name`, `cb`.`description` ;

-- --------------------------------------------------------

--
-- Structure for view `company_balances`
--
DROP TABLE IF EXISTS `company_balances`;

DROP VIEW IF EXISTS `company_balances`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `company_balances`  AS SELECT `comp`.`id` AS `id`, `comp`.`name` AS `name`, `comp`.`phone` AS `phone`, `comp`.`address` AS `address`, coalesce((sum(`t`.`credit_amount`) - sum(`t`.`debit_amount`)),0) AS `current_balance` FROM (`companies` `comp` left join `transactions` `t` on(((`t`.`account_type` = 'company') and (`t`.`account_id` = `comp`.`id`) and (`t`.`is_reversed` = 0)))) GROUP BY `comp`.`id`, `comp`.`name`, `comp`.`phone`, `comp`.`address` ;

-- --------------------------------------------------------

--
-- Structure for view `customer_balances`
--
DROP TABLE IF EXISTS `customer_balances`;

DROP VIEW IF EXISTS `customer_balances`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `customer_balances`  AS SELECT `c`.`id` AS `id`, `c`.`name` AS `name`, `c`.`phone` AS `phone`, `c`.`address` AS `address`, coalesce((sum(`t`.`debit_amount`) - sum(`t`.`credit_amount`)),0) AS `current_balance` FROM (`customers` `c` left join `transactions` `t` on(((`t`.`account_type` = 'customer') and (`t`.`account_id` = `c`.`id`) and (`t`.`is_reversed` = 0)))) GROUP BY `c`.`id`, `c`.`name`, `c`.`phone`, `c`.`address` ;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
